#include <iostream>
using namespace std;

// Vergelijk met overloading.cpp

class Hond {
public:
	Hond(const string& n);
	const string& geefNaam() const;
	virtual ~Hond();
	virtual void print(ostream& o) const;
// ...
private:
	string naam;
};

class SintBernard: public Hond {
public:
	SintBernard(const string& n);
	virtual void print(ostream& o) const;
// ...
};

Hond::Hond(const string& n): naam(n) {
}

const string& Hond::geefNaam() const {
	return naam;
}

void Hond::print(ostream& o) const {
	o<<"Ik ben een Hond en heet: "<<geefNaam()<<endl;
}

Hond::~Hond() {
}

SintBernard::SintBernard(const string& n): Hond(n) {
}

void SintBernard::print(ostream& o) const {
	o<<"Ik ben een Sint Bernard en heet: "<<geefNaam()<<endl;
}

ostream& operator<<(ostream& o, const Hond& h) {
	h.print(o);
	return o;
}

int main() {
	Hond fikkie("Fikkie");
	SintBernard boris("Boris");

	cout<<fikkie;
	cout<<boris;

	Hond* hp(0);
	hp=&fikkie;	// een Hond* kan wijzen naar een Hond
	cout<<*hp;
	hp=&boris;	// een Hond* kan ook wijzen naar een SintBernard
	cout<<*hp;

	cin.get();
	return 0;
}

/*
Uitvoer:
Ik ben een Hond en heet: Fikkie
Ik ben een Sint Bernard en heet: Boris
Ik ben een Hond en heet: Fikkie
Ik ben een Sint Bernard en heet: Boris

Je ziet dat het nu wel goed gaat omdat vanuit de functie:
	ostream& operator<<(ostream& o, const Hond& h);
de virtual memberfunctie print(ostream& o) wordt aangeroepen.

Er wordt dus (tijdens het uitvoeren van het programma) een boodschap
gestuurd naar de door de door de Hond* hp aangewezen hond!
*/
