#include <iostream>
using namespace std;

// Dit voorbeeld laat zien waarom overloading en overerving niet samengaan.
// Een wel werkende oplossing kun je vinden in overriding.cpp

class Hond {
public:
	Hond(const string& n);
	const string& geefNaam() const;
	virtual ~Hond();
// ...
private:
	string naam;
};

class SintBernard: public Hond {
public:
	SintBernard(const string& n);
// ...
};

Hond::Hond(const string& n): naam(n) {
}

const string& Hond::geefNaam() const {
	return naam;
}

Hond::~Hond() {
}

SintBernard::SintBernard(const string& n): Hond(n) {
}

// Gebruik overloading om de operator<< te definieren:

ostream& operator<<(ostream& o, const Hond& h) {
	return o<<"Ik ben een Hond en heet: "<<h.geefNaam()<<endl;
}

ostream& operator<<(ostream& o, const SintBernard& b) {
	return o<<"Ik ben een Sint Bernard en heet: "<<b.geefNaam()<<endl;
}

int main() {
	Hond fikkie("Fikkie");
	SintBernard boris("Boris");

	cout<<fikkie;
	cout<<boris;

	Hond* hp(0);
	hp=&fikkie;	// een Hond* kan wijzen naar een Hond
	cout<<*hp;
	hp=&boris;	// een Hond* kan ook wijzen naar een SintBernard
	cout<<*hp;

	cin.get();
	return 0;
}

/*
Uitvoer:
Ik ben een Hond en heet: Fikkie
Ik ben een Sint Bernard en heet: Boris
Ik ben een Hond en heet: Fikkie
Ik ben een Hond en heet: Boris

Je ziet dat het niet goed gaat omdat bij het kiezen van een functie uit
een aantal overloaded functies het statische type wordt gebruikt dus:
	cout<<*hp;
wordt altijd vertaald in een aanroep naar:
	ostream& operator<<(ostream& o, const Hond& h);

Dit kan ook niet anders want deze keuze wordt al tijdens het vertalen van
het programma gemaakt (en de compiler kan nooit weten naar welk soort Hond de
Hond* hp staat te wijzen tijdens het uitvoeren van het programma!

De oplossing (toepassen van overriding in plaats van overloading) kun je vinden
in overriding.cpp
*/
