#include <iostream>
#include <cassert>
using namespace std;

class SnelheidError {
public:
	virtual ~SnelheidError();
	virtual string getErrorMessage() const =0;
};

SnelheidError::~SnelheidError() {
}

class ReistijdError: public SnelheidError {
public:
	virtual string getErrorMessage() const;
};

string ReistijdError::getErrorMessage() const {
	return "Ongeldige reistijd!";
}

class AfstandError: public SnelheidError {
public:
	virtual string getErrorMessage() const;
};

string AfstandError::getErrorMessage() const {
	return "Ongeldige afstand!";
}

double gemSnelheid(double afstand, int uur, int min) {
	if (afstand<0.0) 
		throw AfstandError();
	if (uur==0 && min==0)
		throw ReistijdError();
	return afstand*60/(uur*60+min);
}

int main() {
	try {
		cout<<gemSnelheid(75.6, 0, 40)<<endl;
		cout<<gemSnelheid(-12.6, 1, 20)<<endl;
		cout<<"Dit was het!"<<endl;
	} catch (SnelheidError& e) {
		cout<<e.getErrorMessage()<<endl;
	}
	cout<<"The END."<<endl;
	cout<<"Druk op Enter: ";
	cin.get();
	return 0;
}

// compile and run .exe to see result!

