#include <iostream>
#include <cassert>
#include <vector>
using namespace std;

// Dit voorbeeld laat zien waarom een Functor handiger is dan een
// functiepointer

// Deze functie geeft de index terug van het eerste element dat aan
// het predicate P voldoet of v.size() als geen enkel element aan het
// predicate P voldoet.

template <typename T, typename P>
vector<T>::size_type findPred(const vector<T>& v, P p) {
	vector<T>::size_type i(0);
	while (i<v.size() && !p(v[i]))
		++i;
	return i;
}

// Als predicate kunnen we een functiepointer meegeven:

bool groterDan_10(int i) {
	return i>10;
}

bool groterDan_11(int i) {
	return i>11;
}

bool groterDan_12(int i) {
	return i>12;
}

// Maar een object is in dit geval handiger!
template <typename T>
class GroterDan {
public:
	GroterDan(const T& t);
	bool operator()(const T& t) const;
private:
	const T& t_;
};

template <typename T>
GroterDan<T>::GroterDan(const T& t): t_(t) {
}

template <typename T>
bool GroterDan<T>::operator()(const T& t) const {
	return t>t_;
}

int main() {
	vector<int> vi;
	vi.push_back(12);
	vi.push_back(11);
	vi.push_back(13);
	vi.push_back(10);
	cout<<"vi = ";
	for (vector<int>::size_type i(0); i<vi.size(); ++i) {
		cout<<vi[i];
		if (i<vi.size()-1)
			cout<<", ";
		else
			cout<<endl;
	}
	cout<<"Index "<<findPred(vi, groterDan_10)<<" is groter dan 10"<<endl;
	cout<<"Index "<<findPred(vi, groterDan_11)<<" is groter dan 11"<<endl;
	cout<<"Index "<<findPred(vi, groterDan_12)<<" is groter dan 12"<<endl;
// Het meegeven van een object is nu handiger
	cout<<"Index "<<findPred(vi, GroterDan<int>(10))<<" is groter dan 10"<<endl;
	cout<<"Index "<<findPred(vi, GroterDan<int>(11))<<" is groter dan 11"<<endl;
	cout<<"Index "<<findPred(vi, GroterDan<int>(12))<<" is groter dan 12"<<endl;
// Het meegeven van een object werkt ook als we het eerste element groter dan x zoeken
	int x;
	cout<<"Geef x: ";
	cin>>x;
	cout<<"Index "<<findPred(vi, GroterDan<int>(x))<<" is groter dan x"<<endl;
	cin.get();
	cin.get();
	return 0;
}

// Zie functor4.cpp
