#include <iostream>
#include <cassert>
#include <vector>
using namespace std;

// Deze oplossing geeft het type van de vergelijking tijdens compile tijd
// door aan de template door middel van een template parameter.

template <typename T, typename F>
const T& findMax(const vector<T>& v, F f) {
	assert(v.size()>0);
	vector<T>::size_type maxIndex(0);
	for (vector<T>::size_type i(1); i<v.size(); ++i)
		if (f(v[maxIndex],v[i]))
			maxIndex=i;
	return v[maxIndex];
}

// Niet elk type heeft een natuurlijke definitie van <

class Rectangle {
public:
	Rectangle(int l, int w);
	int getLength() const;
	int getWidth() const;
	void print(ostream& o) const;
private:
	int length;
	int width;
};

Rectangle::Rectangle(int l, int w): length(l), width(w) {
}

int Rectangle::getLength() const {
	return length;
}

int Rectangle::getWidth() const {
	return width;
}

void Rectangle::print(ostream& o) const {
	o<<length<<'x'<<width;
}


ostream& operator<<(ostream& o, const Rectangle& r) {
	r.print(o);
	return o;
}

// functie voor int
// vergelijk met functor2.cpp
bool lessInt(int i1, int i2) {
	return i1<i2;
}

// functie voor Rectange length
bool lessLength(const Rectangle& r1, const Rectangle& r2) {
	return r1.getLength()<r2.getLength();
}

// functie voor Rectange width
bool lessWidth(const Rectangle& r1, const Rectangle& r2) {
	return r1.getWidth()<r2.getWidth();
}

// functie voor Rectange area
bool lessArea(const Rectangle& r1, const Rectangle& r2) {
	return r1.getLength()*r1.getWidth()<r2.getLength()*r2.getWidth();
}

// je kunt nu ook een object meegeven in plaats van een functie!
// het voordeel hiervan zal in functor4.cpp duidelijk worden.

class RectangeLessArea {
public:
	bool operator()(const Rectangle& r1, const Rectangle& r2) const;
};

bool RectangeLessArea::operator()(const Rectangle& r1, const Rectangle& r2) const {
	return r1.getLength()*r1.getWidth()<r2.getLength()*r2.getWidth();
}

int main() {
	vector<int> vi;
	vi.push_back(12);
	vi.push_back(11);
	vi.push_back(13);
	vi.push_back(10);
	cout<<"Het maximum in vi is: "<<findMax(vi, lessInt)<<endl;
	vector<Rectangle> vr;
	Rectangle r1(5,12);
	Rectangle r2(5,11);
	Rectangle r3(4,13);
	Rectangle r4(6,10);
	vr.push_back(r1);
	vr.push_back(r2);
	vr.push_back(r3);
	vr.push_back(r4);
	cout<<"De maximum length in vr is: "<<findMax(vr, lessLength)<<endl;
	cout<<"De maximum width in vr is: "<<findMax(vr, lessWidth)<<endl;
	cout<<"De maximum area in vr is: "<<findMax(vr, lessArea)<<endl;
// Je kunt nu ook een object meegeven in plaats van een functie!
// Het voordeel hiervan zal in functor4.cpp duidelijk worden.
	cout<<"De maximum area in vr is: "<<findMax(vr, RectangeLessArea())<<endl;
	cin.get();
	return 0;
}

// Zie functor4.cpp
