#include <iostream>
#include <cassert>
#include <vector>
using namespace std;

// Deze oplossing geeft de vergelijking tijdens run time door aan
// de functie door middel van een functiepointer.

template <typename T>
const T& findMax(const vector<T>& v, bool (*f)(const T&, const T&)) {
	assert(v.size()>0);
	vector<T>::size_type maxIndex(0);
	for (vector<T>::size_type i(1); i<v.size(); ++i)
		if (f(v[maxIndex],v[i]))
			maxIndex=i;
	return v[maxIndex];
}

// Niet elk type heeft een natuurlijke definitie van <

class Rectangle {
public:
	Rectangle(int l, int w);
	int getLength() const;
	int getWidth() const;
	void print(ostream& o) const;
private:
	int length;
	int width;
};

Rectangle::Rectangle(int l, int w): length(l), width(w) {
}

int Rectangle::getLength() const {
	return length;
}

int Rectangle::getWidth() const {
	return width;
}

void Rectangle::print(ostream& o) const {
	o<<length<<'x'<<width;
}


ostream& operator<<(ostream& o, const Rectangle& r) {
	r.print(o);
	return o;
}

// functie voor int
/*
bool lessInt(int i1, int i2) {
	return i1<i2;
}
Geeft bij de aanroep:
	cout<<"Het maximum in vi is: "<<findMax(vi, lessInt)<<endl;
de volgende fout:
[C++ Error]: Could not find a match for 'findMax<T>(vector<int,allocator<int> >,bool (*)(int,int))'
Je moet namelijk const int& als parameters gebuiken!
Zie functor3.cpp
*/

bool lessInt(const int& i1, const int& i2) {
	return i1<i2;
}

// functie voor Rectange length
bool lessLength(const Rectangle& r1, const Rectangle& r2) {
	return r1.getLength()<r2.getLength();
}

// functie voor Rectange width
bool lessWidth(const Rectangle& r1, const Rectangle& r2) {
	return r1.getWidth()<r2.getWidth();
}

// functie voor Rectange area
bool lessArea(const Rectangle& r1, const Rectangle& r2) {
	return r1.getLength()*r1.getWidth()<r2.getLength()*r2.getWidth();
}

int main() {
	vector<int> vi;
	vi.push_back(12);
	vi.push_back(11);
	vi.push_back(13);
	vi.push_back(10);
	cout<<"Het maximum in vi is: "<<findMax(vi, lessInt)<<endl;
	vector<Rectangle> vr;
	Rectangle r1(5,12);
	Rectangle r2(5,11);
	Rectangle r3(4,13);
	Rectangle r4(6,10);
	vr.push_back(r1);
	vr.push_back(r2);
	vr.push_back(r3);
	vr.push_back(r4);
	cout<<"De maximum length in vr is: "<<findMax(vr, lessLength)<<endl;
	cout<<"De maximum width in vr is: "<<findMax(vr, lessWidth)<<endl;
	cout<<"De maximum area in vr is: "<<findMax(vr, lessArea)<<endl;
	cin.get();
	return 0;
}

// Zie functor3.cpp
