#include <iostream>
#include <cassert>
#include <vector>
using namespace std;

// Deze findMax gebruikt de operator< om elementen te vergelijken

template <typename T>
const T& findMax(const vector<T>& v) {
	assert(v.size()>0);  // precondition
	vector<T>::size_type maxIndex(0);
	for (vector<T>::size_type i(1); i<v.size(); ++i)
		if (v[maxIndex]<v[i])
			maxIndex=i;
	return v[maxIndex];
}

// Niet elk type heeft een natuurlijke definitie van <

class Rectangle {
public:
	Rectangle(int l, int w);
	int getLength() const;
	int getWidth() const;
	void print(ostream& o) const;
private:
	int length;
	int width;
};

Rectangle::Rectangle(int l, int w): length(l), width(w) {
}

int Rectangle::getLength() const {
	return length;
}

int Rectangle::getWidth() const {
	return width;
}

void Rectangle::print(ostream& o) const {
	o<<length<<'x'<<width;
}


ostream& operator<<(ostream& o, const Rectangle& r) {
	r.print(o);
	return o;
}

int main() {
	vector<int> vi;
	vi.push_back(12);
	vi.push_back(11);
	vi.push_back(13);
	vi.push_back(10);
	cout<<"Het maximum in vi is: "<<findMax(vi)<<endl;
	vector<Rectangle> vr;
	Rectangle r1(5,12);
	Rectangle r2(5,11);
	Rectangle r3(4,13);
	Rectangle r4(6,10);
	vr.push_back(r1);
	vr.push_back(r2);
	vr.push_back(r3);
	vr.push_back(r4);
//	cout<<"Het maximum in vr is: "<<findMax(vr)<<endl;
// Foutmelding op regel 11 (bij instantiation van de template)!
// [C++ Error] functor1.cpp(11): 'operator<' not implemented in type 'Rectangle' for arguments of the same type
	cin.get();
	return 0;
}

// Zie functor2.cpp
