#include <iostream>
using namespace std;

// Klonen van honden met een virtual function met een covariant return type
// Vergelijk met clone.cpp

class Hond {
public:
	Hond(const string& n);
	const string& geefNaam() const;
	virtual ~Hond();
	virtual void print(ostream& o) const;
	virtual Hond* kloon();
// ...
private:
	string naam;
};

class SintBernard: public Hond {
public:
	SintBernard(const string& n);
	virtual void print(ostream& o) const;
	virtual SintBernard* kloon();
// ...
};

Hond::Hond(const string& n): naam(n) {
}

const string& Hond::geefNaam() const {
	return naam;
}

void Hond::print(ostream& o) const {
	o<<"Ik ben een Hond en heet: "<<geefNaam()<<endl;
}

Hond* Hond::kloon() {
	return new Hond(*this);
}

Hond::~Hond() {
}

SintBernard::SintBernard(const string& n): Hond(n) {
}

void SintBernard::print(ostream& o) const {
	o<<"Ik ben een Sint Bernard en heet: "<<geefNaam()<<endl;
}

SintBernard* SintBernard::kloon() {
	return new SintBernard(*this);
}

ostream& operator<<(ostream& o, const Hond& h) {
	h.print(o);
	return o;
}

int main() {
	Hond fikkie("Fikkie");
	SintBernard boris("Boris");

	cout<<fikkie;
	cout<<boris;

	Hond* hp(0);
	hp=fikkie.kloon();
	cout<<*hp;
	delete hp;
	hp=boris.kloon();
	cout<<*hp;
	delete hp;

	SintBernard* bp(0);
	bp=boris.kloon();
	cout<<*bp;
	delete bp;

	cin.get();
	return 0;
}

/*
Uitvoer:
Ik ben een Hond en heet: Fikkie
Ik ben een Sint Bernard en heet: Boris
Ik ben een Hond en heet: Fikkie
Ik ben een Sint Bernard en heet: Boris
Ik ben een Sint Bernard en heet: Boris

Probleem opgelost!
Zie voor het probleem: clone.cpp
*/
