#include <iostream>
using namespace std;

// Dit voorbeeld laat twee manieren zien om constanten in een class
// te definieren.

// Manier 1: met static const datamembers

class Color1 {
public:
	Color1();
	Color1(int c);
	int getValue() const;
	void setValue(int c);
// constanten:
	static const int BLACK = 0x00000000;
	static const int RED = 0x00FF0000;
	static const int YELLOW = 0x00FFFF00;
	static const int GREEN = 0x0000FF00;
	static const int LIGHTBLUE = 0x0000FFFF;
	static const int BLUE = 0x000000FF;
	static const int PURPER = 0x00FF00FF;
	static const int WHITE = 0x00FFFFFF;
// ...
private:
	int value;
};

// Manier 2: met een anonymous enum

class Color2 {
public:
	Color2();
	Color2(int c);
	int getValue() const;
	void setValue(int c);
// constanten:
	enum {
		BLACK = 0x00000000, RED = 0x00FF0000,
		YELLOW = 0x00FFFF00, GREEN = 0x0000FF00,
		LIGHTBLUE = 0x0000FFFF, BLUE = 0x000000FF,
		PURPER = 0x00FF00FF, WHITE = 0x00FFFFFF
// ...
	};
private:
	int value;
};

Color1::Color1(): value(0) {
}
Color1::Color1(int c): value(c&0x00FFFFFF) {
}
int Color1::getValue() const {
	return value;
}
void Color1::setValue(int c) {
	value=c&0x00FFFFFF;
}

Color2::Color2(): value(0) {
}
Color2::Color2(int c): value(c&0x00FFFFFF) {
}
int Color2::getValue() const {
	return value;
}
void Color2::setValue(int c) {
	value=c&0x00FFFFFF;
}

int main() {
	Color1 col1;
	cout<<col1.getValue()<<endl;
	col1.setValue(Color1::YELLOW);
	cout<<col1.getValue()<<endl;
	Color2 col2;
	cout<<col2.getValue()<<endl;
	col2.setValue(Color2::YELLOW);
	cout<<col2.getValue()<<endl;
	cin.get();
	return 0;
}


