#include <math>
#include <stdlib>
using namespace std;
#include "Random.h"

int Random::randomInt() {
	return rand();
}

double Random::randomReal() {
	return randomInt()/static_cast<double>(RAND_MAX);
}

int Random::randomInt(int low, int high) {
	return randomInt()%(high-low+1)+low;
}

int Random::poisson(double expectedValue) {
	double limit(-expectedValue);
	double sum(log(randomReal()));
	int count(0);
	for ( ; sum>limit; ++count)
		sum+=log(randomReal());
	return count;
}

double Random::negExp(double expectedValue) {
	return -expectedValue*log(randomReal());
}
