#ifndef MATRIX_H
#define MATRIX_H

#include <vector>
using namespace std;

template <typename Object>
class matrix {
public:
	typedef vector<Object> row_type;
	typedef typename row_type::size_type row_index;
	typedef typename vector<row_type>::size_type column_index;
	matrix(row_index rows, column_index cols): array(rows) {
		for (row_index i(0); i<rows; ++i)
			array[i].resize(cols);
	}
	const row_type& operator[](row_index row) const {
		return array[row];
	}
	row_type& operator[](row_index row) {
		return array[row];
	}
	row_index numrows() const {
		return array.size();
	}
	column_index numcols() const {
		return numrows()>0 ? array[0].size() : 0;
	}
	void push_back(const row_type& newRow) {
		array.push_back(newRow);
	}
private:
	vector<row_type> array;
};

#endif
