// Een zelfgemaakt alternatief voor int[]
// Deze demo laat zien dat vector1.cpp NIET exception-save is
// vector3.cpp geeft een exception save versie.

#include <iostream>
#include <algorithm>
#include <stdexcept>
#include <cstdlib>

using namespace std;

// operator new[] en delete[] overloaded to test exceptions

// PAS OP: programma loopt vast als teller=0

static int teller=0;
// init teller met 0 om een exception in operator= te veroorzaken
// init teller met 1 of 3 om een exception in constructor te veroorzaken
// init teller met 2 om een exception in copy constructor te veroorzaken
// init teller met 4 om een exception in operator[] te veroorzaken
// init teller met 5 om geen exception te veroorzaken

void* operator new[](size_t s) {
	if (++teller==4)
		throw bad_alloc();
	else
		return malloc(s);
}

void operator delete[](void* p) {
	free(p);
}

class Vector {
public:
	explicit Vector(int);
	Vector(const Vector&);
	Vector& operator=(const Vector&);
	~Vector();
	int& operator[](int);
	const int& operator[](int) const;
	int length() const;
private:
	int size;
	int* data;
friend ostream& operator<<(ostream&, const Vector&);
};

Vector::Vector(int s): size(s), data(new int[s]) {
}

Vector::Vector(const Vector& v): size(v.size), data(new int[v.size]) {
	*this=v;
}

Vector& Vector::operator=(const Vector& r) {
	if (size!=r.size) {
		delete[] data;
		data=new int[r.size];
		size=r.size;
	}
	for (int i(0); i<size; ++i)
		data[i]=r.data[i];
	return *this;
}

Vector::~Vector() {
	delete[] data;
}

int& Vector::operator[](int index) {
	if (index<0 || index>=size)
		throw out_of_range("illegal index for Vector used");
	return data[index];
}

const int& Vector::operator[](int index) const {
	if (index<0 || index>=size)
		throw out_of_range("illegal index for Vector used");
	return data[index];
}

int Vector::length() const {
	return size;
}

ostream& operator<<(ostream& o, const Vector& v) {
	for (int i(0); i<v.size; ++i) {
		o<<v.data[i];
		if (i!=v.size-1)
			o<<',';
	}
	return o;
}

int main() {
	try {
		Vector v(10);
		for (int j(0); j<v.length(); ++j)
			v[j]=j*j;	// vul v met kwadraten
		cout<<"v = "<<v<<endl;
		try {
			Vector w(v);
			cout<<"Aanmaken van w gelukt!"<<endl;
			cout<<"w = "<<w<<endl;
		} catch (bad_alloc& e) {
			cout<<"Aanmaken van w mislukt!"<<endl;
			cout<<"v = "<<v<<endl;
		}
		Vector u(1);
		u[0]=13;
		cout<<"u = "<<u<<endl;
		try {
			u=v;
			cout<<"Toekennen aan u gelukt!"<<endl;
			cout<<"u = "<<u<<endl;
			cout<<"v = "<<v<<endl;
		} catch (bad_alloc& e) {
			cout<<"Toekennen aan u mislukt!"<<endl;
			cout<<"u = "<<u<<endl;
			cout<<"v = "<<v<<endl;
		}
		if (teller==8)
			v[10]=11;
	} catch (bad_alloc& e) {
		cout<<"Aanmaken van u of v mislukt!"<<endl;
	} catch (out_of_range& e) {
		cout<<e.what()<<endl;
	}
	cin.get();
	return 0;
}
