#include <iostream>
#include <cmath>
#include <complex>

using namespace std;

class FrequencyError {
};

class CapacityError {
};

complex<double> impedanceC(double c, double f) {
	if (c==0.0)
		throw CapacityError();
	if (f==0.0)
		throw FrequencyError();
	return complex<double>(0, -1/(2*M_PI*f*c));
}

int main() {
	try {
		cout<<impedanceC(1e-6, 1e3)<<endl;
		cin.get();
		cout<<impedanceC(1e-6, 0)<<endl;
		cout<<"Dit was het!"<<endl;
	} catch (CapacityError& e) {
		cout<<"Capaciteit == 0"<<endl;
	} catch (FrequencyError& e) {
		cout<<"Frequentie == 0"<<endl;
	}
	cin.get();
	cout<<"The END."<<endl;
	cin.get();
	return 0;
}

/*
C:\SOP2>impC.exe
(0,-159.155)

Frequentie == 0

The END.


C:\SOP2>
*/
