#include <iostream>
#include <cmath>
#include <complex>

using namespace std;

complex<double> impedanceC(double c, double f) {
	return complex<double>(0, -1/(2*M_PI*f*c));
}

int main() {
	cout<<impedanceC(1e-6, 1e3)<<endl;
	cin.get();
	cout<<impedanceC(1e-6, 0)<<endl;
	cin.get();
	cout<<"The END."<<endl;
	cin.get();
	return 0;
}

/*
IMPC heeft een uitzondering 10H veroorzaakt in module IMPC.EXE op 0177:0040116b.
Registers:
EAX=0063fdf8 CS=0177 EIP=0040116b EFLGS=00010207
EBX=00530000 SS=017f ESP=0063fdb8 EBP=0063fdc8
ECX=325998f0 DS=017f ESI=0040704c FS=4847
EDX=0063fdf8 ES=017f EDI=00000000 GS=0000
Bytes in CS:EIP:
dd 5d f8 33 d2 89 55 f0 89 55 f4 8b 4d f0 89 08
Stackdump:
32599934 325998f0 00403301 32599934 0063fe30 0040120c 0063fdf8 a0b5ed8d 3eb0c6f7 00000000 00000000 004033b8 00000000 00000000 4b370dd0 c063e4f5
*/
