//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner), currentx(0), currenty(0), dragging(false) {
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Panel1MouseMove(TObject *Sender, TShiftState Shift, int X, int Y) {
        // Only move when actually dragging
        if (dragging) {
                // Cast to the right class type
                TPanel* p(dynamic_cast<TPanel*>(Sender));
                if (p!=0) {
                        // Set the movement distance
                        int offsetx = X - currentx;
                        int offsety = Y - currenty;

                        // Apply constraints here
                        if ((p->Left + offsetx) < 0)
                                offsetx = -p->Left;

                        if ((p->Top + offsety) < 0)
                                offsety = -p->Top;

                        if ((p->Left + offsetx + p->Width) > ClientWidth)
                                offsetx -= (p->Left + offsetx + p->Width) - ClientWidth;

                        if ((p->Top + offsety + p->Height) > ClientHeight)
                                offsety -= (p->Top + offsety + p->Height) - ClientHeight;

                        // Move object but DO NOT adjust currentx, since Left is already
                        // compensating for that.
                        p->Left += offsetx;
                        p->Top += offsety;
                }
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Panel1MouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
        // Cast to the right class type
        TPanel* p(dynamic_cast<TPanel*>(Sender));
        if (p!=0) {
               // Start dragging
                currentx = X;
                currenty = Y;
                dragging=true;
                p->BringToFront();
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Panel1MouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
        // Stop dragging
        dragging=false;
}
//---------------------------------------------------------------------------
