// Template class Vector

#include <iostream>
#include <cmath>
#include <cassert>
using namespace std;

template <typename T> class Vector {
public:
	explicit Vector(int s);
	Vector(const Vector<T>& v);
	Vector<T>& operator=(const Vector<T>& r);
	~Vector();
	T& operator[](int index);
	const T& operator[](int index) const;
	int length() const;
	bool operator==(const Vector<T>& r) const;
	bool operator!=(const Vector<T>& r) const;
private:
	int size;
	T* data;
};

template <typename T> Vector<T>::Vector(int s): size(s), data(new T[s]) {
}

template <typename T> Vector<T>::Vector(const Vector<T>& v): size(v.size), data(new T[v.size]) {
	*this=v;
}

template <typename T> Vector<T>& Vector<T>::operator=(const Vector<T>& r) {
	if (size!=r.size) {
		delete[] data;
		data=new T[r.size];
		size=r.size;
	}
	for (int i(0); i<size; ++i)
		data[i]=r.data[i];
	return *this;
}

template <typename T> Vector<T>::~Vector() {
	delete[] data;
}

template <typename T> T& Vector<T>::operator[](int index) {
	assert(index>=0 && index<size);
	return data[index];
}

template <typename T> const T& Vector<T>::operator[](int index) const {
	assert(index>=0 && index<size);
	return data[index];
}

template <typename T> int Vector<T>::length() const {
	return size;
}

template <typename T> bool Vector<T>::operator==(const Vector<T>& r) const {
	if (size!=r.size)
	return false;
	for (int i(0); i<size; ++i)
		if (data[i]!=r.data[i])
			return false;
	return true;
}

template <typename T> bool Vector<T>::operator!=(const Vector<T>& r) const {
	return !(*this==r);
}

template <typename T> ostream& operator<<(ostream& o, const Vector<T>& v) {
	for (int i(0); i<v.size; ++i) {
		o<<v.data[i];
		if (i!=v.size-1)
			o<<',';
	}
	return o;
}

int main() {
	cout<<"Hoeveel elementen moet de vector bevatten? ";
	int i; cin>>i;
	if (i>0) {
		Vector<double> v(i);
		for (int j(0); j<v.length(); ++j)
			v[j]=sqrt(double(j));	// Vul v met wortels
		cout<<"v[12] = "<<v[12]<<endl;
		Vector<int> w(i);
		for (int t(0); t<w.length(); ++t)
			w[t]=t*t;	        // Vul w met kwadraten
		cout<<"w[12] = "<<w[12]<<endl;
	}
	else
		cout<<"Doe niet zo negatief!"<<endl;
	cin.get();
	cin.get();
	return 0;
}
