// Voorbeeld van slicing probleem

#include <iostream>
using namespace std;

class Mens {
public:
	virtual ~Mens() {
	}
	virtual void printSoort() {
		cout<<"Mens.";
	}
	virtual void printSalaris() {
		cout<<"Salaris = 0";
	}
// ...
};

class Docent: public Mens {
public:
	Docent(): salaris(30000) {
	}
	virtual void printSoort() {
		cout<<"Docent.";
	}
	virtual void printSalaris() {
		cout<<"Salaris = "<<salaris;
	}
	virtual void verhoogSalarisMet(unsigned short v) {
		salaris+=v;
	}
// ...
private:
	unsigned short salaris;
};

int main() {
	Docent Bd;

	Bd.printSoort(); cout<<" ";
	Bd.printSalaris(); cout<<endl;
	Bd.verhoogSalarisMet(10000);
	Bd.printSalaris(); cout<<endl;

	Mens m(Bd); // Waar blijft het salaris?
	m.printSoort(); cout<<" ";
	m.printSalaris(); cout<<endl;

	Docent Dd(m); // [C++ Error]: Could not find a match for 'Docent::Docent(Mens)'

	Mens& mr(Bd);
	mr.printSoort(); cout<<" ";
	mr.printSalaris(); cout<<endl;

	Mens* mp(&Bd);
	mp->printSoort(); cout<<" ";
	mp->printSalaris(); cout<<endl;

	cin.get();
	return 0;
}

/*
Output:
Docent. Salaris = 30000
Salaris = 40000
Mens. Salaris = 0
Docent. Salaris = 40000
Docent. Salaris = 40000
*/
