// Werken met breuken in C++ ... operator overloading

#include <iostream>
#include <cassert>
using namespace std;

// Class interface vertelt wat je met een object van de class kunt
// doen.

class Breuk {
public:
	Breuk(int t, int n);
	int teller() const;
	int noemer() const;
	Breuk& operator+=(const Breuk& right);
//	...
//	Er zijn nog veel uitbreidingen mogelijk
//	...
private:
	int boven;
	int onder;
	void normaliseer();
};

// Hulpfunctie: bepaald de grootste gemene deler.

int ggd(int n, int m) {
	assert(n>=0 && m>=0);
	if (n==0) return m;
	if (m==0) return n;
	while (m!=n)
		if (n>m) n-=m;
		else m-=n;
	return n;
}

// Class implementatie vertelt je hoe de class in elkaar zit. Dit is
// voor gebruikers van de class niet van belang.

Breuk::Breuk(int t, int n): boven(t), onder(n) {
	normaliseer();
}

int Breuk::teller() const {
	return boven;
}

int Breuk::noemer() const {
	return onder;
}

Breuk& Breuk::operator+=(const Breuk& right) {
	boven=boven*right.onder + onder*right.boven;
	onder*=right.onder;
	normaliseer();
	return *this;
}

void Breuk::normaliseer() {
	assert(onder!=0);
	if (onder<0) {
		onder=-onder;
		boven=-boven;
	}
	int d(ggd(boven<0?-boven:boven,onder));
	boven/=d;
	onder/=d;
}

int main() {
	Breuk b1(14, 4);
	cout<<"b1(14, 4) ==> "
		 <<b1.teller()<<'/'<<b1.noemer()<<endl;
	Breuk b2(23, -5);
	cout<<"b2(23, -5) ==> "
		 <<b2.teller()<<'/'<<b2.noemer()<<endl;
	b1+=b2;
	cout<<"b1+=b2 ==> "
		 <<b1.teller()<<'/'<<b1.noemer()<<endl;

	cin.get();
	return 0;
}

/* Output:
b1(14, 4) ==> 7/2
b2(23, -5) ==> -23/5
b1+=b2 ==> -11/10
*/


