#ifndef _adccard_
#define _adccard_

class ADCCard {
public:
	ADCCard();
	virtual ~ADCCard();
	virtual void selectChannel(int channel) =0;
	int getChannel() const;
	virtual void setAmplifier(double factor) =0;
	double read() const;
protected:
	void rememberChannel(int channel);
	void rememberAmplifier(double factor);
private:
	double f; 		// amplifying factor
	int c;			// selected channel
	virtual int sample() const =0;
};

ostream& operator<<(ostream& out, const ADCCard& card);

#endif

