// operator[] moet twee maal gedefinieerd worden

#include <iostream>
#include <cassert>
using namespace std;

/*
	overloaden van operator[] ...

	je moet altijd twee memberfuncties definieren zodat "het" werkt met const
	objecten en ook met non-const objecten:

	T& operator[](int);		 // called for non-const object
	const T& operator[](int) const;  // called for const object

	Vector5  is niet correct
	Vector6	is niet correct
	Vector10 is wel correct
*/

class Vector5 {
public:
	Vector5();
	int& operator[](int index) const;
private:
	int data[5];
};

Vector5::Vector5() {
	for (int i(0); i<5; ++i)
		data[i]=0;
}

int& Vector5::operator[](int index) const {
	assert(index<5);
//	return data[index];
//	[C++ Error]: Reference initialized with 'const int', needs lvalue of type 'int'
//	de compiler herkend de fout!
//	We kunnen daar wel om heen werken, maar dan kun je ook in een const
//	Vector5 schrijven en dat is niet de bedoeling:
	return (int&)(data[index]);
}

class Vector6 {
public:
	Vector6();
	int& operator[](int index);
private:
	int data[6];
};

Vector6::Vector6() {
	for (int i(0); i<6; ++i)
		data[i]=0;
}

int& Vector6::operator[](int index) {
	assert(index<6);
	return data[index];
}

class Vector10 {
public:
	Vector10();
	int& operator[](int index);
	const int& operator[](int index) const;
private:
	int data[10];
};

Vector10::Vector10() {
	for (int i(0); i<10; ++i)
		data[i]=0;
}

int& Vector10::operator[](int index) {
	assert(index<10);
	return data[index];
}

const int& Vector10::operator[](int index) const {
	assert(index<10);
	return data[index];
}

int main() {
	Vector5 v5;
	for (int i(0); i<5; ++i)
		v5[i]=i;
	const Vector5 w5(v5);
	w5[0]=5;
//	Schrijven in een const vector moet niet mogen maar mag hier wel!
	for (int i(0); i<5; ++i)
		cout<<v5[i];
	cout<<endl;
	for (int i(0); i<5; ++i)
		cout<<w5[i];
	cout<<endl;

	Vector6 v6;
	for (int j(0) ;j<6; ++j)
		v6[j]=j;
	const Vector6 w6(v6);
//	w6[0]=6;
//	[C++ Error]: 'operator+' not implemented in type 'Vector6' for arguments of type 'int'
//	Vreemde foutmelding!
	for (int j(0); j<6; ++j)
		cout<<v6[j];
	cout<<endl;
//	for (int j(0); j<6; ++j)
//		cout<<w6[j];
//	[C++ Error]: 'operator+' not implemented in type 'Vector6' for arguments of type 'int'
//	Vreemde foutmelding!
//	Lezen uit een const vector moet wel mogen maar mag hier niet!
	cout<<endl;

	Vector10 v10;
	for (int k(0); k<10; ++k)
		v10[k]=k;
	const Vector10 w10(v10);
//	w10[0]=10;
//	[C++ Error]: Cannot modify a const object
	for (int k(0); k<10; ++k)
		cout<<v10[k];
	cout<<endl;
	for (int k(0); k<10; ++k)
		cout<<w10[k];
	cout<<endl;

	cin.get();
	return 0;
}
