// Voorbeeld van gebruik van ABC, virtual destructor en polymorphism

#include <iostream>
using namespace std;

class Fruit {
public:
	/*virtual*/ ~Fruit() {
		cout<<"Er is een stuk Fruit verwijderd."<<endl;
	}
	virtual void printSoort()=0;
// ...
};

class Appel: public Fruit {
public:
	virtual ~Appel() {
		cout<<"Er is een Appel verwijderd."<<endl;
	}
	virtual void printSoort() {
		cout<<"Appel."<<endl;
	}
// ...
};

class Peer: public Fruit {
public:
	virtual ~Peer() {
		cout<<"Er is een Peer verwijderd."<<endl;
	}
	virtual void printSoort() {
		cout<<"Peer."<<endl;
	}
// ...
};

class FruitMand {
public:
	FruitMand(): aantal(0) {
	}
	~FruitMand() {
		for (int i(0); i<aantal; ++i)
			delete fp[i];
	}
	void voegToe(Fruit* p) {
		if (aantal<100)
			fp[aantal++]=p;
		else
			cout<<"De mand is al vol."<<endl;
	}
	void printInhoud() {
		cout<<"De fruitmand bevat:"<<endl;
		for (int i(0); i<aantal; ++i)
			fp[i]->printSoort();
	}
private:
	int aantal;
	Fruit* fp[100]; // fruitmand kan niet meer dan 100 stuks fruit bevatten
};

int main() {
	FruitMand m;
	m.voegToe(new Appel);
	m.voegToe(new Peer);
	m.voegToe(new Appel);
	m.printInhoud();

	cin.get();
	return 0;
}

/* Uitvoer (in DOS window):
Appel.
Peer.
Appel.

Er is een Appel verwijderd.
Er is een stuk Fruit verwijderd.
Er is een Peer verwijderd.
Er is een stuk Fruit verwijderd.
Er is een Appel verwijderd.
Er is een stuk Fruit verwijderd.

*/

// Als we de constructor in de class Fruit *NIET* virtual maken:
/* Uitvoer (in DOS window):

De fruitmand bevat:
Appel.
Peer.
Appel.

Er is een stuk Fruit verwijderd.
Er is een stuk Fruit verwijderd.
Er is een stuk Fruit verwijderd.

*/
