// C++ als een betere C

#include <iostream>
#include <iomanip>
#include <fstream>
using namespace std;

struct Tijdsduur {	// Een Tijdsduur bestaat uit:
	int uur;	         //    een aantal uren en
	int min;	         //    een aantal minuten.
};

// Deze functie drukt een Tijdsduur af
void drukaf(Tijdsduur td) {
	if (td.uur==0)
		cout<<"           ";
	else
		cout<<setw(3)<<td.uur<<" uur en ";
	cout<<setw(2)<<td.min<<" minuten"<<endl;
}

// Deze functie drukt een rij met n gewerkte tijden af
void drukaf(Tijdsduur trij[], int n) {
	for (int teller(0);teller<n;++teller)
		drukaf(trij[teller]);
}

// Deze functie berekent de totaal gewerkte tijd uit een rij met n
// gewerkte tijden
Tijdsduur som(Tijdsduur trij[], int n) {
	Tijdsduur s;
	s.uur=s.min=0;
	for (int teller(0);teller<n;++teller) {
		s.uur+=trij[teller].uur;
		s.min+=trij[teller].min;
	}
	s.uur+=s.min/60;
	s.min%=60;
	return s;
}

int main () {
	ifstream fin("lijst.txt");
	if (fin!=0) {
		const int MAX(100);
		Tijdsduur rij[MAX];
		int aantal=0;
		while (fin>>rij[aantal].uur>>rij[aantal].min && aantal<MAX)
			++aantal;
		if (fin!=0)
			cout<<"De file is niet volledig uitgelezen!\n"<<endl;
		drukaf(rij, aantal);
		cout<<"De totaal gewerkte tijd is:"<<endl;
		drukaf(som(rij, aantal));
	}
	else
		cout<<"Het bestand lijst.txt kan niet worden geopend!"<<endl;
	cin.get();
	return 0;
}
