// Een oplossing m.b.v. een ADT ... wel herbruikbaar niet onderhoudbaar (aanpasbaar)

#include <iostream>
#include <iomanip>
using namespace std;

enum CardName {AD178, NI323};

class ADCCard {
public:
	ADCCard(CardName name);
	void selectChannel(int channel);
	int getChannel() const;
	void setAmplifier(double factor);
	double read() const;
private:
	CardName t; // card type
	double f;   // amplifying factor
	int c;     // selected channel
	int sample() const;
};

ostream& operator<<(ostream& out, const ADCCard& card) {
	return out<<setprecision(5)<<card.read()<<" V.";
}

ADCCard::ADCCard(CardName name): t(name), f(1.0), c(1) {
	// eventueel voor alle kaarten benodigde code
	switch (t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"AD178 is geinitialiseeerd."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"NI323 is geinitialiseeerd."<<endl;
			break;
	}
	// eventueel voor alle kaarten benodigde code.
}

void ADCCard::selectChannel(int channel) {
	c=channel;
	// eventueel voor alle kaarten benodigde code
	switch (t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"Kanaal "<<channel<<" van AD178 is geselecteerd."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"Kanaal "<<channel<<" van NI323 is geselecteerd."<<endl;
			break;
	}
	// eventueel voor alle kaarten benodigde code.
}

int ADCCard::getChannel() const {
	return c;
}

void ADCCard::setAmplifier(double factor) {
	f=factor;
	// eventueel voor alle kaarten benodigde code
	switch (t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"Versterkingsfactor van AD178 is "<<factor<<"."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"Versterkingsfactor van NI323 is "<<factor<<"."<<endl;
			break;
	}
	// eventueel voor alle kaarten benodigde code.
}

int ADCCard::sample() const {
	int sample;
	// eventueel voor alle kaarten benodigde code
	switch (t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			sample=0x7FFF; // +5*f V
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			sample=0x8000; // -5*f V
			break;
	}
	// eventueel voor alle kaarten benodigde code.
	return sample;
}

double ADCCard::read() const {
	return sample()*f/6553.5;
}

int main() {
	ADCCard k1(AD178);
	k1.setAmplifier(10);
	k1.selectChannel(3);
	cout<<"Kanaal "<<k1.getChannel()<<" van kaart k1 = "<<k1<<endl;
	ADCCard k2(NI323);
	k2.setAmplifier(5);
	k2.selectChannel(4);
	cout<<"Kanaal "<<k2.getChannel()<<" van kaart k2 = "<<k2<<endl;

	cin.get();
	return 0;
}
