// Een gestructureerde oplossing ... zo deden we het vroeger!

#include <iostream>
#include <iomanip>
using namespace std;

enum CardName {AD178, NI323};

struct ADCCard {
	CardName t; // card type
	double f;   // amplifying factor
	int c;      // selected channel
};

void initCard(ADCCard& card, CardName name) {
	card.t=name;
	card.f=1.0;
	card.c=1;
	// eventueel voor alle kaarten benodigde code
	switch (card.t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"AD178 is geinitialiseeerd."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"NI323 is geinitialiseeerd."<<endl;
			break;
	}
	// eventueel voor alle kaarten benodigde code.
}

void selectChannel(ADCCard& card, int channel) {
	card.c=channel;
	// eventueel voor alle kaarten benodigde code
	switch (card.t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"Kanaal "<<channel<<" van AD178 is geselecteerd."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"Kanaal "<<channel<<" van NI323 is geselecteerd."<<endl;
			break;
	}
	// eventueel voor alle kaarten benodigde code.
}

int getChannel(const ADCCard& card) {
	return card.c;
}

void setAmplifier(ADCCard& card, double factor) {
	card.f=factor;
	// eventueel voor alle kaarten benodigde code
	switch (card.t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			cout<<"Versterkingsfactor van AD178 is "<<factor<<"."<<endl;
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			cout<<"Versterkingsfactor van NI323 is "<<factor<<"."<<endl;
			break;
		}
	// eventueel voor alle kaarten benodigde code.
}

int sampleCard(const ADCCard& card) {
	int sample;
	// eventueel voor alle kaarten benodigde code
	switch (card.t) {
		case AD178:
			// de specifieke voor de AD178 benodigde code
			sample=0x7FFF; // +5*f V
			break;
		case NI323:
			// de specifieke voor de NI323 benodigde code
			sample=0x8000; // -5*f V
			break;
	}
	// eventueel voor alle kaarten benodigde code.
	return sample;
}

double readCard(const ADCCard& card) {
	return sampleCard(card)*card.f/6553.5;
}

int main() {
	ADCCard c1;
	initCard(c1, AD178);
	setAmplifier(c1, 10);
	selectChannel(c1, 3);
	cout<<"Kanaal "<<getChannel(c1)<<" van kaart c1 = "<<setprecision(5)<<readCard(c1)<<" V."<<endl;
	ADCCard c2;
	initCard(c2, NI323);
	setAmplifier(c2, 5);
	selectChannel(c2, 4);
	cout<<"Kanaal "<<getChannel(c2)<<" van kaart c2 = "<<setprecision(5)<<readCard(c2)<<" V."<<endl;

	cin.get();
	return 0;
}
