// Constante definieren met const i.p.v. #define

int main() {
	int i(3);
	const int j(24);

	// Een constante moet je initialiseren:
	const int k;
	// Fout: Constant variable 'k' must be initialized

	// Een constante mag je niet veranderen:
	j=7;
	// Fout: Cannot modify a const object

	const int* p(&i);
	// p wijst naar i en je kan i niet via p wijzigen. Let op: je kan i zelf
	// wel wijzigen!
	i=4;
	// Goed
	*p=5;
	// Fout: Cannot modify a const object
	p=&j;
	// Goed

	int* const q(&i);
	// q wijst naar i en je kan q nergens anders meer naar laten wijzen. Let
	// op: je kan i wel via q (of rechtstreeks) wijzigen.
	i=4;
	// Goed
	*q=5;
	// Goed
	q=&j;
	// Fout: Cannot modify a const object

	const int* const r(&i);
	// r wijst naar i en je kan i niet via r wijzigen en je kan r nergens
	// anders meer naar laten wijzen. Let op: je kan i zelf wel wijzigen!
	i=4;
	// Goed
	*r=5;
	// Fout: Cannot modify a const object
	r=&j;
	// Fout: Cannot modify a const object
	return 0;
}

