/* Een terugblik op functie, struct, array en file */

#include <stdio.h>     /* nodig voor gebruik printf (schrijven naar scherm),
								  FILE, fopen, foef en fscanf (lezen uit file) */

struct Tijdsduur {   /* Een Tijdsduur bestaat uit:	*/
	int uur;	         /*    een aantal uren en	*/
	int min;	         /*    een aantal minuten.	*/
};

/* Deze functie drukt een Tijdsduur af */
void drukaf(struct Tijdsduur td) {
	if (td.uur==0)
		printf("           %2d minuten\n", td.min);
	else
		printf("%3d uur en %2d minuten\n", td.uur, td.min);
}

/* Deze functie drukt een rij met n gewerkte tijden af */
void drukafRij(struct Tijdsduur trij[], int n) {
	int teller;
	for (teller=0;teller<n;++teller)
		drukaf(trij[teller]);
}

/* Deze functie berekent de totaal gewerkte tijd
	uit een rij met n gewerkte tijden */
struct Tijdsduur som(struct Tijdsduur trij[], int n) {
	int teller;
	struct Tijdsduur s;
	s.uur=s.min=0;
	for (teller=0;teller<n;++teller) {
		s.uur+=trij[teller].uur;
		s.min+=trij[teller].min;
	}
	s.uur+=s.min/60;
	s.min%=60;
	return s;
}

#define MAX	100

int main () {
	FILE* fp=fopen("lijst.txt", "r");/* Open bestand "lijst.txt" voor invoer. */
	if (fp!=NULL) {			 /* Test of openen gelukt is. */
		struct Tijdsduur rij[MAX];
		int aantal=0;		    /* Het aantal ingelezen gewerkte tijden. */
		while (aantal<MAX && fscanf(fp, "%d%d", &rij[aantal].uur, &rij[aantal].min)!=EOF)
			++aantal;	       /* Lezen uit bestand tot array vol of end-of-file. */
		if (feof(fp)==0)      /* Test of er nog meer uit de file gelezen kan worden. */
			printf("De array is vol maar de file nog niet geheel gelezen\n");
		drukafRij(rij, aantal);
		printf("De totaal gewerkte tijd is:\n");
		drukaf(som(rij, aantal));
		fclose(fp);
	}
	else
		printf("De file lijst.txt kan niet worden geopend!\n");
	getchar();
	return 0;
}
