/* Werken met breuken in C ... zo deden we het vroeger! */

#include <stdio.h>

struct Breuk {	        /* een breuk bestaat uit: */
	int boven; 	/*	een teller en     */
	int onder;	/*	een noemer        */
};

unsigned int ggd(unsigned int n, unsigned int m) {
	if (n==0) return m;
	if (m==0) return n;
	while (m!=n)
		if (n>m) n-=m;
		else m-=n;
	return n;
}

struct Breuk normaliseer(struct Breuk b) {
	int d;
	if (b.onder<0) {
		b.onder=-b.onder;
		b.boven=-b.boven;
	}
	d=ggd(b.boven<0?-b.boven:b.boven,b.onder);
	b.boven/=d;
	b.onder/=d;
	return b;
}

struct Breuk som(struct Breuk b1, struct Breuk b2) {
	struct Breuk s;
	s.boven=b1.boven*b2.onder + b1.onder*b2.boven;
	s.onder=b1.onder*b2.onder;
	return normaliseer(s);
}

int main() {
	struct Breuk a, b, c;
	a.boven=2; a.onder=4;
	b.boven=6; b.onder=8;

	c=som(a, b);
	printf("c = %d/%d\n", c.boven, c.onder);

	getchar();
	return 0;
}