// Werken met breuken in C++ ... constructor, destructor, const memberfuncties

#include <iostream>
#include <cassert>
using namespace std;

// Class interface vertelt wat je met een object van de class kunt
// doen.

class Breuk {
public:
	Breuk();
	Breuk(int t);
	Breuk(int t, int n);
	~Breuk();
	int teller() const;
	int noemer() const;
	void plus(const Breuk& b);
	void abs();
//	...
//	Er zijn nog veel uitbreidingen mogelijk
//	...
private:
	int boven;
	int onder;
	void normaliseer();
};

// Hulpfunctie: bepaald de grootste gemene deler.

int ggd(int n, int m) {
	assert(n>=0 && m>=0);
	if (n==0) return m;
	if (m==0) return n;
	while (m!=n)
		if (n>m) n-=m;
		else m-=n;
	return n;
}

// Class implementatie vertelt je hoe de class in elkaar zit. Dit is
// voor gebruikers van de class niet van belang.

Breuk::Breuk(): boven(0), onder(1) {
}

Breuk::Breuk(int t): boven(t), onder(1) {
}

Breuk::Breuk(int t, int n): boven(t), onder(n) {
	normaliseer();
}

Breuk::~Breuk() {
	cout<<"Er wordt een Breuk object verwijderd"<<endl;
}

inline int Breuk::teller() const {
	return boven;
}

inline int Breuk::noemer() const {
	return onder;
}

void Breuk::plus(const Breuk& b) {
	boven=boven*b.onder + onder*b.boven;
	onder*=b.onder;
	normaliseer();
}

void Breuk::abs() {
	boven=boven<0?-boven:boven;
}

void Breuk::normaliseer() {
	assert(onder!=0);
	if (onder<0) {
		onder=-onder;
		boven=-boven;
	}
	int d(ggd(boven<0?-boven:boven,onder));
	boven/=d;
	onder/=d;
}

int main() {
	{ // nutteloos haakje?
		Breuk b1(4);
		cout<<"b1(4) ==> "
			 <<b1.teller()<<'/'<<b1.noemer()<<endl;
	}
	Breuk b2(23, -5);
	cout<<"b2(23, -5) ==> "
		 <<b2.teller()<<'/'<<b2.noemer()<<endl;
	Breuk b3(b2);
	cout<<"b3(b2) ==> "
		 <<b3.teller()<<'/'<<b3.noemer()<<endl;
	b3.abs();
	cout<<"b3.abs() ==> "
		 <<b3.teller()<<'/'<<b3.noemer()<<endl;
	b3=b2;
	cout<<"b3=b2 ==> "
		 <<b3.teller()<<'/'<<b3.noemer()<<endl;
	b3.plus(5);
	cout<<"b3.plus(5) ==> "
		 <<b3.teller()<<'/'<<b3.noemer()<<endl;

	const Breuk halve(1,2);
	cout<<"halve ==> "
		 <<halve.teller()<<'/'<<halve.noemer()<<endl;

//	halve=b3;
//	[C++ Error]: Cannot modify a const object
	halve.plus(b3);
//	[C++ Warning]: Non-const function Breuk::plus(const Breuk &) called for const object
//	(This is an error, but was reduced to a warning to give existing programs a chance to work.)
//	OOPS

	b3=halve;
	cout<<"b3=halve ==> "
		 <<b3.teller()<<'/'<<b3.noemer()<<endl;

	cin.get();
	return 0;
}
