import java.util.concurrent.*;

public class TestBoundedBuffer {
   public static void main(String[] args) {
      if (args.length!=3) {
         System.err.println("Usage: java TestBoundedBuffer <Priority Consumer> <Priority Frikadel Producer> <Priority Kroket Producer>");
         System.err.println("Minimum Priority = "+Thread.MIN_PRIORITY);
         System.err.println("Maximum Priority = "+Thread.MAX_PRIORITY);
         System.err.println("Normal Priority = "+Thread.NORM_PRIORITY);
      }
      else {
         BlockingQueue<Character> b=new ArrayBlockingQueue<Character>(16);
         char frikadel='F';
         char kroket='K';
         Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
         Thread tc =new Thread(new Consumer(b));
         Thread tp1=new Thread(new Producer(frikadel, b));
         Thread tp2=new Thread(new Producer(kroket, b));
         tc.setPriority(Integer.parseInt(args[0]));
         tp1.setPriority(Integer.parseInt(args[1]));
         tp2.setPriority(Integer.parseInt(args[2]));
         System.out.println("Output voor Consumer priority = "+tc.getPriority()+
                            " Frikadel Producer priority = "+tp1.getPriority()+
                            " Kroket Producer priority = "+tp2.getPriority());
         tc.start();
         tp1.start();
         tp2.start();
      }
   }
}