<HTML>
<BODY>
<PRE>import java.util.concurrent.locks.*;

public class ReadersWriters3 {
	private int readers=0;
	private int waitingWriters=0;
	private boolean writing=false;
	private Lock lock = new ReentrantLock();
	private Condition okToRead = lock.newCondition(); 
	private Condition okToWrite = lock.newCondition(); 
	public void startWrite() throws InterruptedException {
		lock.lock();
		while (writing || readers&gt;0) {
			waitingWriters++;
			okToWrite.await();
			waitingWriters--;
		}
		writing=true;
		lock.unlock();
	}
	public void stopWrite() {
		lock.lock();
		writing=false;
		if (waitingWriters&gt;0) {
			okToWrite.signal(); // wakeup one writer
		}
		else {
			okToRead.signalAll(); // wakeup all readers
		}
		lock.unlock();
	}
	public void startRead() throws InterruptedException { 
		lock.lock();
		while (writing || waitingWriters&gt;0) {
			okToRead.await();
		}
		readers++;
		lock.unlock();
	} 
	public void stopRead() {
		lock.lock();
		readers--;
		if (readers==0 &amp;&amp; waitingWriters&gt;0) {
			okToWrite.signal(); // wakeup one writer
		}
		lock.unlock();
	}  
}

</PRE>
</BODY></HTML>
