public class ReadersWriters1 {
	private int readers=0;
	private int waitingWriters=0;
	private boolean writing=false;
	public synchronized void startWrite() throws InterruptedException {
		while (readers>0 || writing) {
			waitingWriters++;
			wait();
			waitingWriters--;
		}
		writing=true;
	}
	public synchronized void stopWrite() {
		writing=false;
		notifyAll();
	}
	public synchronized void startRead() throws InterruptedException {
		while (writing || waitingWriters>0) 
			wait();
		readers++;
	}
	public synchronized void stopRead() {
		readers--;
		if (readers==0) 
			notifyAll();
	}
}

