#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

struct par {
	char* s;
	int ns;
};

void check(int error) {
	if (error!=0) {
		fprintf(stderr, "Error: %s\n", strerror(error));
		exit(EXIT_FAILURE);
	}
}

void* print(void* p) {
	struct par* pp=p;
	struct timespec ts={0, pp->ns};
	int i;
	for (i=0; i<10; ++i) {
		nanosleep(&ts, NULL);
		printf(pp->s);
	}
}

int main(int argc, char *argv[]) {
	pthread_t p1, p2;

	struct par par1={"print1\n", 10000000}, par2={"print2\n", 20000000};

	check( pthread_create(&p1, NULL, print, &par1) );
	check( pthread_create(&p2, NULL, print, &par2) );

	check( pthread_join(p1, NULL) );
	check( pthread_join(p2, NULL) );

	return EXIT_SUCCESS;
}
