#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

void check(int error) {
	if (error!=0) {
		fprintf(stderr, "Error: %s\n", strerror(error));
		exit(EXIT_FAILURE);
	}
}

void* print1(void* arg) {
	struct timespec ts={0, 10000000};
	int i;
	for (i=0; i<10; ++i) {
		nanosleep(&ts, NULL);
		printf("print1\n");
	}
}

void* print2(void* arg) {
	struct timespec ts={0, 20000000};
	int i;
	for (i=0; i<10; ++i) {
		nanosleep(&ts, NULL);
		printf("print2\n");
	}
}

int main(int argc, char *argv[]) {
	pthread_t p1, p2;

	check( pthread_create(&p1, NULL, print1, NULL) );
	check( pthread_create(&p2, NULL, print2, NULL) );

	check( pthread_join(p1, NULL) );
	check( pthread_join(p2, NULL) );

	return EXIT_SUCCESS;
}
