#include <stdio.h>
#include <stdlib.h>

double readTemp(void) {
//	dummy: should read temperature from ADC
	static double val=0.0;
	val+=0.5;
	if (val>20.0)
		val=0.0;	
	return val;
}

void writeSwitch(int i) {
//	dummy: should write to switch
}

double readPres(void) {
//	dummy: should read pressure from ADC
	static double val=20.0;
	val-=0.4;
	if (val<0.0)
		val=20.0;	
	return val;
}

void writeDAC(double d) {
//	dummy: should write to DAC
}

int tempConvert(double temp) {
//	dummy: should use better algorithm
	static struct timespec ms100={0, 100000000};
	nanosleep(&ms100, NULL);
	return  temp>10.0;
}

double presConvert(double pres) {
//	dummy: should use better algorithm
	static struct timespec ms100={0, 100000000};
	nanosleep(&ms100, NULL);
	return 10.0-pres;
}

int main(void) {
	double temp, pres, dac;
	int switch_;
	while (1) {
		temp=readTemp();
		switch_=tempConvert(temp);
		writeSwitch(switch_);
		pres=readPres();
		dac=presConvert(pres);
		writeDAC(dac);
		printf("temperature = %4.1lf, pressure = %4.1lf, switch = %d, DAC = %5.1lf\n", temp, pres, switch_, dac);
	}
	return EXIT_SUCCESS;
}
