import java.text.*;

public class TempThread extends Thread {
	private double temp;
	private boolean switch_;
 	public TempThread() {
 		temp=0.0;
 	}
 	private void readTemp() {
	//	dummy: should read temperature from ADC
		temp+=0.5;
		if (temp>20.0)
			temp=0.0;	
	}
	private void writeSwitch() {
	//	dummy: should write to switch
	}
	private void tempConvert() {
	//	dummy: should use better algorithm
		try {
			sleep(100);
	 	} catch (InterruptedException e) {}
		switch_=temp>10.0;
	}
 	public void run() {
		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumIntegerDigits(2);
 		nf.setMinimumFractionDigits(1);
 		nf.setMaximumFractionDigits(1);
		while (true) {
			readTemp();
			synchronized(System.out) {
				System.out.print("temperature = "+nf.format(temp)+", ");
				tempConvert();
				System.out.println("switch = "+switch_);
			}
			writeSwitch();
			try {
				sleep(3000);
		 	} catch (InterruptedException e) {}
		}
	}
}
